if(tutorial_settings == nil) then
  tutorial_settings = {played = false}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
end)

set_user_input_filter(permissive_filter)
function tutorial_routine()
  return coroutine.wrap(function()
    set_user_input_filter(restrictive_filter)
    state:suppress_toolbar_menu();
    state:suppress_transport_menu();
    state:suppress_interface_hints();
    embed(announce("You're on your own for this factory.", 4, 0.06, captured_cancel()))
    embed(pause(0.25))
    embed(announce("Use portals to rotate and flip objects.", 4, 0.06, captured_cancel()))
    state:suppress_toolbar_menu(false);
    embed(pause(0.25))
    embed(ramp(4, do_all(
      announce_lambda("Use the delete tool if you mess up", 0.06),
      announce_lambda("(Or press Z to undo)", 0.04, -0.06),
      highlight_menu_item_lambda("toolbar_0")
    ), captured_cancel()))
    state:suppress_transport_menu(false);
    state:suppress_interface_hints(false);
    set_user_input_filter(permissive_filter)
    embed(pause(0.25))
    embed(announce("Good luck!", 3, 0.15, captured_cancel()))
  end)
end
if not played_in_past then
  draw_interpreted_routine(tutorial_routine())
end
